% Read EXCEL input: B = xlsread('myfile.xls','Sheet 1','B10:F28')
% "share"	"eps_target"	"eps_calib" "eta_target"	"eta_calib"
data = xlsread('.\input\elastheta.xlsx','3x3','B3:F5');

% Check Engel's aggregation (variable engel = 1 must hold)
% submatrix = fullMatrix(row1:row2, column1:column2);
eta_target = data(1:3, 4:4);
theta = data(1:3, 1:1);
engel = theta'*eta_target;

% Create a diagonal matrix with diagonal terms being the own-price AUES elasticities
eps_target = data(1:3, 2:2);
theta_diag = diag(theta);
aues_diag = diag(inv(theta_diag)*eps_target);

% For the 3X3 case, solve for the off-diagonal AUES terms by Cournot aggregation
thetam = [theta(2,1) theta(3,1) 0; theta(1,1) 0 theta(3,1); 0 theta(1,1) theta(2,1)];
thetasigma = -aues_diag*theta;
aues_offd = inv(thetam)*thetasigma;
aues = aues_diag + [0 aues_offd(1,1) aues_offd(2,1); 
                    aues_offd(1,1) 0 aues_offd(3,1);
                    aues_offd(2,1) aues_offd(3,1) 0];

% Check if the AUES matrix is NSD
det_aues11 = det(aues(1:1, 1:1));
det_aues22 = det(aues(1:2, 1:2));
det_aues33 = det(aues(1:3, 1:3));
